/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.sound;

import com.group_finity.mascot.Main;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.sound.sampled.Clip;

public class Sounds {
    private static final ConcurrentHashMap<String, Clip> SOUNDS = new ConcurrentHashMap();

    public static void load(String filename, Clip clip) {
        if (!SOUNDS.containsKey(filename)) {
            SOUNDS.put(filename, clip);
        }
    }

    public static boolean contains(String filename) {
        return SOUNDS.containsKey(filename);
    }

    public static Clip getSound(String filename) {
        if (!SOUNDS.containsKey(filename)) {
            return null;
        }
        return SOUNDS.get(filename);
    }

    public static ArrayList<Clip> getSoundsIgnoringVolume(String filename) {
        ArrayList<Clip> sounds = new ArrayList<Clip>(5);
        Enumeration<String> keys = SOUNDS.keys();
        while (keys.hasMoreElements()) {
            String soundName = keys.nextElement();
            if (!soundName.startsWith(filename)) continue;
            sounds.add(SOUNDS.get(soundName));
        }
        return sounds;
    }

    public static boolean isMuted() {
        return !Boolean.parseBoolean(Main.getInstance().getProperties().getProperty("Sounds", "true"));
    }

    public static void setMuted(boolean mutedFlag) {
        if (mutedFlag) {
            Enumeration<String> keys = SOUNDS.keys();
            while (keys.hasMoreElements()) {
                SOUNDS.get(keys.nextElement()).stop();
            }
        }
    }
}

