/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.config;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.config.ActionBuilder;
import com.group_finity.mascot.config.BehaviorBuilder;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.ActionInstantiationException;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import com.joconner.i18n.Utf8ResourceBundleControl;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private static final Logger log = Logger.getLogger(Configuration.class.getName());
    private final Map<String, String> constants = new LinkedHashMap<String, String>(2);
    private final Map<String, ActionBuilder> actionBuilders = new LinkedHashMap<String, ActionBuilder>();
    private final Map<String, BehaviorBuilder> behaviorBuilders = new LinkedHashMap<String, BehaviorBuilder>();
    private final Map<String, String> information = new LinkedHashMap<String, String>(8);
    private ResourceBundle schema;

    public void load(Entry configurationNode, String imageSet) throws IOException, ConfigurationException {
        Locale locale;
        log.log(Level.INFO, "Start Reading Configuration File...");
        Utf8ResourceBundleControl utf8Control = new Utf8ResourceBundleControl(false);
        if (configurationNode.hasChild("\u52d5\u4f5c\u30ea\u30b9\u30c8") || configurationNode.hasChild("\u884c\u52d5\u30ea\u30b9\u30c8")) {
            log.log(Level.INFO, "Using ja-JP schema");
            locale = Locale.forLanguageTag("ja-JP");
        } else {
            log.log(Level.INFO, "Using en-US schema");
            locale = Locale.forLanguageTag("en-US");
        }
        this.schema = ResourceBundle.getBundle("schema", locale, utf8Control);
        for (Entry constant : configurationNode.selectChildren(this.schema.getString("Constant"))) {
            this.getConstants().put(constant.getAttribute(this.schema.getString("Name")), constant.getAttribute(this.schema.getString("Value")));
        }
        for (Entry list : configurationNode.selectChildren(this.schema.getString("ActionList"))) {
            log.log(Level.INFO, "Action List...");
            for (Entry node : list.selectChildren(this.schema.getString("Action"))) {
                ActionBuilder action = new ActionBuilder(this, node, imageSet);
                if (this.getActionBuilders().containsKey(action.getName())) {
                    throw new ConfigurationException(Main.getInstance().getLanguageBundle().getString("DuplicateActionErrorMessage") + ": " + action.getName());
                }
                this.getActionBuilders().put(action.getName(), action);
            }
        }
        for (Entry list : configurationNode.selectChildren(this.schema.getString("BehaviourList"))) {
            log.log(Level.INFO, "Behavior List...");
            this.loadBehaviors(list, new ArrayList<String>());
        }
        for (Entry list : configurationNode.selectChildren(this.schema.getString("Information"))) {
            log.log(Level.INFO, "Information List...");
            this.loadInformation(list);
        }
        log.log(Level.INFO, "Configuration loaded successfully");
    }

    private void loadBehaviors(Entry list, List<String> conditions) {
        for (Entry node : list.getChildren()) {
            if (node.getName().equals(this.schema.getString("Condition"))) {
                ArrayList<String> newConditions = new ArrayList<String>(conditions);
                newConditions.add(node.getAttribute(this.schema.getString("Condition")));
                this.loadBehaviors(node, newConditions);
                continue;
            }
            if (!node.getName().equals(this.schema.getString("Behaviour"))) continue;
            BehaviorBuilder behavior = new BehaviorBuilder(this, node, conditions);
            this.getBehaviorBuilders().put(behavior.getName(), behavior);
        }
    }

    public Action buildAction(String name, Map<String, String> params) throws ActionInstantiationException {
        ActionBuilder factory = this.actionBuilders.get(name);
        if (factory == null) {
            throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("NoCorrespondingActionFoundErrorMessage") + ": " + name);
        }
        return factory.buildAction(params);
    }

    private void loadInformation(Entry list) {
        for (Entry node : list.getChildren()) {
            String linkText;
            if (node.getName().equals(this.schema.getString("Name")) || node.getName().equals(this.schema.getString("PreviewImage")) || node.getName().equals(this.schema.getString("SplashImage"))) {
                this.information.put(node.getName(), node.getText());
                continue;
            }
            if (!node.getName().equals(this.schema.getString("Artist")) && !node.getName().equals(this.schema.getString("Scripter")) && !node.getName().equals(this.schema.getString("Commissioner")) && !node.getName().equals(this.schema.getString("Support"))) continue;
            String nameText = node.getAttribute(this.schema.getString("Name")) != null ? node.getAttribute(this.schema.getString("Name")) : null;
            String string = linkText = node.getAttribute(this.schema.getString("URL")) != null ? node.getAttribute(this.schema.getString("URL")) : null;
            if (nameText == null) continue;
            this.information.put(node.getName() + this.schema.getString("Name"), nameText);
            if (linkText == null) continue;
            this.information.put(node.getName() + this.schema.getString("URL"), linkText);
        }
    }

    public void validate() throws ConfigurationException {
        for (ActionBuilder actionBuilder : this.getActionBuilders().values()) {
            actionBuilder.validate();
        }
        for (BehaviorBuilder behaviorBuilder : this.getBehaviorBuilders().values()) {
            behaviorBuilder.validate();
        }
    }

    public Behavior buildNextBehavior(String previousName, Mascot mascot) throws BehaviorInstantiationException {
        VariableMap context = new VariableMap();
        context.putAll(this.getConstants());
        context.put("mascot", (Object)mascot);
        ArrayList<BehaviorBuilder> candidates = new ArrayList<BehaviorBuilder>();
        long totalFrequency = 0L;
        for (BehaviorBuilder behaviorFactory : this.getBehaviorBuilders().values()) {
            try {
                if (!behaviorFactory.isEffective(context) || !this.isBehaviorEnabled(behaviorFactory, mascot)) continue;
                candidates.add(behaviorFactory);
                totalFrequency += (long)behaviorFactory.getFrequency();
            }
            catch (VariableException e) {
                log.log(Level.WARNING, "An error occurred calculating the frequency of the action", e);
            }
        }
        if (previousName != null) {
            BehaviorBuilder previousBehaviorFactory = this.getBehaviorBuilders().get(previousName);
            if (!previousBehaviorFactory.isNextAdditive()) {
                totalFrequency = 0L;
                candidates.clear();
            }
            for (BehaviorBuilder behaviorFactory : previousBehaviorFactory.getNextBehaviorBuilders()) {
                try {
                    if (!behaviorFactory.isEffective(context) || !this.isBehaviorEnabled(behaviorFactory, mascot)) continue;
                    candidates.add(behaviorFactory);
                    totalFrequency += (long)behaviorFactory.getFrequency();
                }
                catch (VariableException e) {
                    log.log(Level.WARNING, "An error occurred calculating the frequency of the behavior", e);
                }
            }
        }
        if (totalFrequency == 0L) {
            if (Boolean.parseBoolean(Main.getInstance().getProperties().getProperty("Multiscreen", "true"))) {
                mascot.setAnchor(new Point((int)(Math.random() * (double)(mascot.getEnvironment().getScreen().getRight() - mascot.getEnvironment().getScreen().getLeft())) + mascot.getEnvironment().getScreen().getLeft(), mascot.getEnvironment().getScreen().getTop() - 256));
            } else {
                mascot.setAnchor(new Point((int)(Math.random() * (double)(mascot.getEnvironment().getWorkArea().getRight() - mascot.getEnvironment().getWorkArea().getLeft())) + mascot.getEnvironment().getWorkArea().getLeft(), mascot.getEnvironment().getWorkArea().getTop() - 256));
            }
            return this.buildBehavior(this.schema.getString("Fall"));
        }
        double random = Math.random() * (double)totalFrequency;
        for (BehaviorBuilder behaviorFactory : candidates) {
            if (!((random -= (double)behaviorFactory.getFrequency()) < 0.0)) continue;
            return behaviorFactory.buildBehavior();
        }
        return null;
    }

    public Behavior buildBehavior(String name, Mascot mascot) throws BehaviorInstantiationException {
        if (this.behaviorBuilders.containsKey(name)) {
            if (this.isBehaviorEnabled(name, mascot)) {
                return this.getBehaviorBuilders().get(name).buildBehavior();
            }
            if (Boolean.parseBoolean(Main.getInstance().getProperties().getProperty("Multiscreen", "true"))) {
                mascot.setAnchor(new Point((int)(Math.random() * (double)(mascot.getEnvironment().getScreen().getRight() - mascot.getEnvironment().getScreen().getLeft())) + mascot.getEnvironment().getScreen().getLeft(), mascot.getEnvironment().getScreen().getTop() - 256));
            } else {
                mascot.setAnchor(new Point((int)(Math.random() * (double)(mascot.getEnvironment().getWorkArea().getRight() - mascot.getEnvironment().getWorkArea().getLeft())) + mascot.getEnvironment().getWorkArea().getLeft(), mascot.getEnvironment().getWorkArea().getTop() - 256));
            }
            return this.buildBehavior(this.schema.getString("Fall"));
        }
        throw new BehaviorInstantiationException(Main.getInstance().getLanguageBundle().getString("NoBehaviourFoundErrorMessage") + " (" + name + ")");
    }

    public Behavior buildBehavior(String name) throws BehaviorInstantiationException {
        if (this.behaviorBuilders.containsKey(name)) {
            return this.getBehaviorBuilders().get(name).buildBehavior();
        }
        throw new BehaviorInstantiationException(Main.getInstance().getLanguageBundle().getString("NoBehaviourFoundErrorMessage") + " (" + name + ")");
    }

    public boolean isBehaviorEnabled(BehaviorBuilder builder, Mascot mascot) {
        if (builder.isToggleable()) {
            for (String behaviour : Main.getInstance().getProperties().getProperty("DisabledBehaviours." + mascot.getImageSet(), "").split("/")) {
                if (!behaviour.equals(builder.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBehaviorEnabled(String name, Mascot mascot) {
        if (this.behaviorBuilders.containsKey(name)) {
            return this.isBehaviorEnabled(this.getBehaviorBuilders().get(name), mascot);
        }
        return false;
    }

    public boolean isBehaviorHidden(String name) {
        if (this.behaviorBuilders.containsKey(name)) {
            return this.getBehaviorBuilders().get(name).isHidden();
        }
        return false;
    }

    public boolean isBehaviorToggleable(String name) {
        if (this.behaviorBuilders.containsKey(name)) {
            return this.getBehaviorBuilders().get(name).isToggleable();
        }
        return false;
    }

    private Map<String, String> getConstants() {
        return this.constants;
    }

    Map<String, ActionBuilder> getActionBuilders() {
        return this.actionBuilders;
    }

    private Map<String, BehaviorBuilder> getBehaviorBuilders() {
        return this.behaviorBuilders;
    }

    public Set<String> getBehaviorNames() {
        return this.behaviorBuilders.keySet();
    }

    public boolean containsInformationKey(String key) {
        return this.information.containsKey(key);
    }

    public String getInformation(String key) {
        return this.information.get(key);
    }

    public ResourceBundle getSchema() {
        return this.schema;
    }
}

