/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.DebugWindow;
import com.group_finity.mascot.Main;
import com.group_finity.mascot.Manager;
import com.group_finity.mascot.NativeFactory;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.environment.Area;
import com.group_finity.mascot.environment.MascotEnvironment;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.hotspot.Hotspot;
import com.group_finity.mascot.image.MascotImage;
import com.group_finity.mascot.image.TranslucentWindow;
import com.group_finity.mascot.menu.JLongMenu;
import com.group_finity.mascot.sound.Sounds;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.Clip;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Mascot {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Mascot.class.getName());
    private static AtomicInteger lastId = new AtomicInteger();
    private final int id;
    private String imageSet = "";
    private final TranslucentWindow window = NativeFactory.getInstance().newTransparentWindow();
    private Manager manager = null;
    private Point anchor = new Point(0, 0);
    private MascotImage image = null;
    private boolean lookRight = false;
    private Behavior behavior = null;
    private int time = 0;
    private boolean animating = true;
    private boolean paused = false;
    private boolean dragging = false;
    private MascotEnvironment environment = new MascotEnvironment(this);
    private String sound = null;
    protected DebugWindow debugWindow = null;
    private ArrayList<String> affordances = new ArrayList(5);
    private ArrayList<Hotspot> hotspots = new ArrayList(5);
    private Point cursor = null;

    public Mascot(String imageSet) {
        this.id = lastId.incrementAndGet();
        this.imageSet = imageSet;
        log.log(Level.INFO, "Created a mascot ({0})", this);
        this.getWindow().setAlwaysOnTop(true);
        this.getWindow().asComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Mascot.this.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Mascot.this.mouseReleased(e);
            }
        });
        this.getWindow().asComponent().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (Mascot.this.paused) {
                    Mascot.this.refreshCursor(false);
                } else if (Mascot.this.isHotspotClicked()) {
                    Mascot.this.setCursorPosition(e.getPoint());
                } else {
                    Mascot.this.refreshCursor(e.getPoint());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Mascot.this.paused) {
                    Mascot.this.refreshCursor(false);
                } else if (Mascot.this.isHotspotClicked()) {
                    Mascot.this.setCursorPosition(e.getPoint());
                } else {
                    Mascot.this.refreshCursor(e.getPoint());
                }
            }
        });
    }

    public String toString() {
        return "mascot" + this.id;
    }

    private void mousePressed(MouseEvent event) {
        if (!this.isPaused() && this.getBehavior() != null) {
            try {
                this.getBehavior().mousePressed(event);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "Fatal Error", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("SevereShimejiErrorErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
                this.dispose();
            }
        }
    }

    private void mouseReleased(final MouseEvent event) {
        if (event.isPopupTrigger()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Mascot.this.showPopup(event.getX(), event.getY());
                }
            });
        } else if (!this.isPaused() && this.getBehavior() != null) {
            try {
                this.getBehavior().mouseReleased(event);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "Fatal Error", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("SevereShimejiErrorErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
                this.dispose();
            }
        }
    }

    private void showPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        final ResourceBundle languageBundle = Main.getInstance().getLanguageBundle();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Mascot.this.setAnimating(true);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Mascot.this.setAnimating(false);
            }
        });
        JMenuItem increaseMenu = new JMenuItem(languageBundle.getString("CallAnother"));
        increaseMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Main.getInstance().createMascot(Mascot.this.imageSet);
            }
        });
        JMenuItem disposeMenu = new JMenuItem(languageBundle.getString("Dismiss"));
        disposeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mascot.this.dispose();
            }
        });
        JMenuItem gatherMenu = new JMenuItem(languageBundle.getString("FollowCursor"));
        gatherMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Mascot.this.getManager().setBehaviorAll(Main.getInstance().getConfiguration(Mascot.this.imageSet), "ChaseMouse", Mascot.this.imageSet);
            }
        });
        JMenuItem oneMenu = new JMenuItem(languageBundle.getString("DismissOthers"));
        oneMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Mascot.this.getManager().remainOne(Mascot.this.imageSet);
            }
        });
        JMenuItem onlyOneMenu = new JMenuItem(languageBundle.getString("DismissAllOthers"));
        onlyOneMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Mascot.this.getManager().remainOne(Mascot.this);
            }
        });
        JMenuItem restoreMenu = new JMenuItem(languageBundle.getString("RestoreWindows"));
        restoreMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NativeFactory.getInstance().getEnvironment().restoreIE();
            }
        });
        JMenuItem debugMenu = new JMenuItem(languageBundle.getString("RevealStatistics"));
        debugMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Mascot.this.debugWindow == null) {
                    Mascot.this.debugWindow = new DebugWindow();
                }
                Mascot.this.debugWindow.setVisible(true);
            }
        });
        JMenuItem closeMenu = new JMenuItem(languageBundle.getString("DismissAll"));
        closeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.getInstance().exit();
            }
        });
        JMenuItem pauseMenu = new JMenuItem(this.isAnimating() ? languageBundle.getString("PauseAnimations") : languageBundle.getString("ResumeAnimations"));
        pauseMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Mascot.this.setPaused(!Mascot.this.isPaused());
            }
        });
        JLongMenu submenu = new JLongMenu(languageBundle.getString("SetBehaviour"), 30);
        JLongMenu allowedSubmenu = new JLongMenu(languageBundle.getString("AllowedBehaviours"), 30);
        submenu.setAutoscrolls(true);
        final Configuration config = Main.getInstance().getConfiguration(this.getImageSet());
        Iterator<String> iterator = config.getBehaviorNames().iterator();
        while (iterator.hasNext()) {
            String behaviorName;
            final String command = behaviorName = iterator.next();
            try {
                if (config.isBehaviorHidden(command)) continue;
                String caption = behaviorName.replaceAll("([a-z])(IE)?([A-Z])", "$1 $2 $3").replaceAll("  ", " ");
                if (config.isBehaviorEnabled(command, this) && !command.contains("/")) {
                    JMenuItem item = new JMenuItem(languageBundle.containsKey(behaviorName) ? languageBundle.getString(behaviorName) : caption);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Mascot.this.setBehavior(config.buildBehavior(command));
                            }
                            catch (Exception err) {
                                log.log(Level.SEVERE, "Error ({0})", this);
                                Main.showError(languageBundle.getString("CouldNotSetBehaviourErrorMessage") + "\n" + err.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
                            }
                        }
                    });
                    submenu.add(item);
                }
                if (!config.isBehaviorToggleable(command) || command.contains("/")) continue;
                JCheckBoxMenuItem toggleItem = new JCheckBoxMenuItem(caption, config.isBehaviorEnabled(command, this));
                toggleItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        Main.getInstance().setMascotBehaviorEnabled(command, Mascot.this, !config.isBehaviorEnabled(command, Mascot.this));
                    }
                });
                allowedSubmenu.add(toggleItem);
            }
            catch (Exception exception) {}
        }
        popup.add(increaseMenu);
        popup.add(new JSeparator());
        popup.add(gatherMenu);
        popup.add(restoreMenu);
        popup.add(debugMenu);
        popup.add(new JSeparator());
        if (submenu.getMenuComponentCount() > 0) {
            popup.add(submenu);
        }
        if (allowedSubmenu.getMenuComponentCount() > 0) {
            popup.add(allowedSubmenu);
        }
        popup.add(new JSeparator());
        popup.add(pauseMenu);
        popup.add(new JSeparator());
        popup.add(disposeMenu);
        popup.add(oneMenu);
        popup.add(onlyOneMenu);
        popup.add(closeMenu);
        this.getWindow().asComponent().requestFocus();
        popup.setLightWeightPopupEnabled(false);
        popup.show(this.getWindow().asComponent(), x, y);
    }

    void tick() {
        if (this.isAnimating()) {
            if (this.getBehavior() != null) {
                try {
                    this.getBehavior().next();
                }
                catch (CantBeAliveException e) {
                    log.log(Level.SEVERE, "Fatal Error.", e);
                    Main.showError(Main.getInstance().getLanguageBundle().getString("CouldNotGetNextBehaviourErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
                    this.dispose();
                }
                this.setTime(this.getTime() + 1);
            }
            if (this.debugWindow != null) {
                this.debugWindow.setBehaviour(this.behavior.toString().substring(9, this.behavior.toString().length() - 1).replaceAll("([a-z])(IE)?([A-Z])", "$1 $2 $3").replaceAll("  ", " "));
                this.debugWindow.setShimejiX(this.anchor.x);
                this.debugWindow.setShimejiY(this.anchor.y);
                Area activeWindow = this.environment.getActiveIE();
                this.debugWindow.setWindowTitle(this.environment.getActiveIETitle());
                this.debugWindow.setWindowX(activeWindow.getLeft());
                this.debugWindow.setWindowY(activeWindow.getTop());
                this.debugWindow.setWindowWidth(activeWindow.getWidth());
                this.debugWindow.setWindowHeight(activeWindow.getHeight());
                Area workArea = this.environment.getWorkArea();
                this.debugWindow.setEnvironmentX(workArea.getLeft());
                this.debugWindow.setEnvironmentY(workArea.getTop());
                this.debugWindow.setEnvironmentWidth(workArea.getWidth());
                this.debugWindow.setEnvironmentHeight(workArea.getHeight());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        if (this.isAnimating()) {
            if (this.getImage() != null) {
                this.getWindow().asComponent().setBounds(this.getBounds());
                this.getWindow().setImage(this.getImage().getImage());
                if (!this.getWindow().asComponent().isVisible()) {
                    this.getWindow().asComponent().setVisible(true);
                }
                this.getWindow().updateImage();
            } else if (this.getWindow().asComponent().isVisible()) {
                this.getWindow().asComponent().setVisible(false);
            }
            if (!Sounds.isMuted() && this.sound != null && Sounds.contains(this.sound)) {
                Logger logger = log;
                synchronized (logger) {
                    Clip clip = Sounds.getSound(this.sound);
                    if (!clip.isRunning()) {
                        clip.stop();
                        clip.setMicrosecondPosition(0L);
                        clip.start();
                    }
                }
            }
        }
    }

    public void dispose() {
        log.log(Level.INFO, "destroy mascot ({0})", this);
        if (this.debugWindow != null) {
            this.debugWindow.setVisible(false);
            this.debugWindow = null;
        }
        this.animating = false;
        this.getWindow().dispose();
        if (this.getManager() != null) {
            this.getManager().remove(this);
        }
    }

    private void refreshCursor(Point position) {
        boolean useHand = false;
        for (Hotspot hotspot : this.hotspots) {
            if (!hotspot.contains(this, position) || !Main.getInstance().getConfiguration(this.imageSet).isBehaviorEnabled(hotspot.getBehaviour(), this)) continue;
            useHand = true;
            break;
        }
        this.refreshCursor(useHand);
    }

    private void refreshCursor(Boolean useHand) {
        this.getWindow().asComponent().setCursor(Cursor.getPredefinedCursor(useHand != false ? 12 : 0));
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Point anchor) {
        this.anchor = anchor;
    }

    public MascotImage getImage() {
        return this.image;
    }

    public void setImage(MascotImage image) {
        this.image = image;
    }

    public boolean isLookRight() {
        return this.lookRight;
    }

    public void setLookRight(boolean lookRight) {
        this.lookRight = lookRight;
    }

    public Rectangle getBounds() {
        if (this.getImage() != null) {
            int top = this.getAnchor().y - this.getImage().getCenter().y;
            int left = this.getAnchor().x - this.getImage().getCenter().x;
            Rectangle result = new Rectangle(left, top, this.getImage().getSize().width, this.getImage().getSize().height);
            return result;
        }
        return this.getWindow().asComponent().getBounds();
    }

    public int getTime() {
        return this.time;
    }

    private void setTime(int time) {
        this.time = time;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Behavior behavior) throws CantBeAliveException {
        this.behavior = behavior;
        this.behavior.init(this);
    }

    public int getCount() {
        return this.manager != null ? this.getManager().getCount(this.imageSet) : 0;
    }

    public int getTotalCount() {
        return this.manager != null ? this.getManager().getCount() : 0;
    }

    private boolean isAnimating() {
        return this.animating && !this.paused;
    }

    private void setAnimating(boolean animating) {
        this.animating = animating;
    }

    private TranslucentWindow getWindow() {
        return this.window;
    }

    public MascotEnvironment getEnvironment() {
        return this.environment;
    }

    public ArrayList<String> getAffordances() {
        return this.affordances;
    }

    public ArrayList<Hotspot> getHotspots() {
        return this.hotspots;
    }

    public void setImageSet(String set) {
        this.imageSet = set;
    }

    public String getImageSet() {
        return this.imageSet;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String name) {
        this.sound = name;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    public boolean isHotspotClicked() {
        return this.cursor != null;
    }

    public Point getCursorPosition() {
        return this.cursor;
    }

    public void setCursorPosition(Point point) {
        this.cursor = point;
        if (point == null) {
            this.refreshCursor(false);
        } else {
            this.refreshCursor(point);
        }
    }
}

