/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.config;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.behavior.UserBehavior;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.ActionInstantiationException;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.Variable;
import com.group_finity.mascot.script.VariableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BehaviorBuilder {
    private static final Logger log = Logger.getLogger(BehaviorBuilder.class.getName());
    private final Configuration configuration;
    private final String name;
    private final String actionName;
    private final int frequency;
    private final List<String> conditions;
    private final boolean hidden;
    private final boolean nextAdditive;
    private final List<BehaviorBuilder> nextBehaviorBuilders = new ArrayList<BehaviorBuilder>();
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    public BehaviorBuilder(Configuration configuration, Entry behaviorNode, List<String> conditions) {
        this.configuration = configuration;
        this.name = behaviorNode.getAttribute(configuration.getSchema().getString("Name"));
        this.actionName = behaviorNode.getAttribute(configuration.getSchema().getString("Action")) == null ? this.getName() : behaviorNode.getAttribute(configuration.getSchema().getString("Action"));
        this.frequency = Integer.parseInt(behaviorNode.getAttribute(configuration.getSchema().getString("Frequency")));
        this.hidden = Boolean.parseBoolean(behaviorNode.getAttribute(configuration.getSchema().getString("Hidden")));
        this.conditions = new ArrayList<String>(conditions);
        this.getConditions().add(behaviorNode.getAttribute(configuration.getSchema().getString("Condition")));
        log.log(Level.INFO, "Start Reading({0})", this);
        this.getParams().putAll(behaviorNode.getAttributes());
        this.getParams().remove(configuration.getSchema().getString("Name"));
        this.getParams().remove(configuration.getSchema().getString("Action"));
        this.getParams().remove(configuration.getSchema().getString("Frequency"));
        this.getParams().remove(configuration.getSchema().getString("Hidden"));
        this.getParams().remove(configuration.getSchema().getString("Condition"));
        boolean nextAdditive = true;
        for (Entry nextList : behaviorNode.selectChildren(configuration.getSchema().getString("NextBehaviourList"))) {
            log.log(Level.INFO, "Lists the Following Behaviors...");
            nextAdditive = Boolean.parseBoolean(nextList.getAttribute(configuration.getSchema().getString("Add")));
            this.loadBehaviors(nextList, new ArrayList<String>());
        }
        this.nextAdditive = nextAdditive;
        log.log(Level.INFO, "Behaviors have finished loading({0})", this);
    }

    public String toString() {
        return "Behavior(" + this.getName() + "," + this.getFrequency() + "," + this.getActionName() + ")";
    }

    private void loadBehaviors(Entry list, List<String> conditions) {
        for (Entry node : list.getChildren()) {
            if (node.getName().equals(this.configuration.getSchema().getString("Condition"))) {
                ArrayList<String> newConditions = new ArrayList<String>(conditions);
                newConditions.add(node.getAttribute(this.configuration.getSchema().getString("Condition")));
                this.loadBehaviors(node, newConditions);
                continue;
            }
            if (!node.getName().equals(this.configuration.getSchema().getString("BehaviourReference"))) continue;
            BehaviorBuilder behavior = new BehaviorBuilder(this.getConfiguration(), node, conditions);
            this.getNextBehaviorBuilders().add(behavior);
        }
    }

    public void validate() throws ConfigurationException {
        if (!this.getConfiguration().getActionBuilders().containsKey(this.getActionName())) {
            log.log(Level.SEVERE, "There is no corresponding action(" + this + ")");
            throw new ConfigurationException(Main.getInstance().getLanguageBundle().getString("NoActionFoundErrorMessage") + "(" + this + ")");
        }
    }

    public Behavior buildBehavior() throws BehaviorInstantiationException {
        try {
            return new UserBehavior(this.getName(), this.getConfiguration().buildAction(this.getActionName(), this.getParams()), this.getConfiguration(), this.isHidden());
        }
        catch (ActionInstantiationException e) {
            log.log(Level.SEVERE, "Failed to initialize the corresponding action(" + this + ")");
            throw new BehaviorInstantiationException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseCorrespondingActionErrorMessage") + "(" + this + ")", e);
        }
    }

    public boolean isEffective(VariableMap context) throws VariableException {
        for (String condition : this.getConditions()) {
            if (condition == null || ((Boolean)Variable.parse(condition).get(context)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private String getActionName() {
        return this.actionName;
    }

    private Map<String, String> getParams() {
        return this.params;
    }

    private List<String> getConditions() {
        return this.conditions;
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isNextAdditive() {
        return this.nextAdditive;
    }

    public List<BehaviorBuilder> getNextBehaviorBuilders() {
        return this.nextBehaviorBuilders;
    }
}

