/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Jump;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.awt.Point;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BreedJump
extends Jump {
    private static final Logger log = Logger.getLogger(BreedJump.class.getName());
    public static final String PARAMETER_BORNX = "BornX";
    private static final int DEFAULT_BORNX = 0;
    public static final String PARAMETER_BORNY = "BornY";
    private static final int DEFAULT_BORNY = 0;
    public static final String PARAMETER_BORNBEHAVIOUR = "BornBehaviour";
    private static final String DEFAULT_BORNBEHAVIOUR = "";
    public static final String PARAMETER_BORNMASCOT = "BornMascot";
    private static final String DEFAULT_BORNMASCOT = "";
    public static final String PARAMETER_BORNINTERVAL = "BornInterval";
    private static final int DEFAULT_BORNINTERVAL = 1;
    public static final String PARAMETER_BORNTRANSIENT = "BornTransient";
    private static final boolean DEFAULT_BORNTRANSIENT = false;
    private double scaling;

    public BreedJump(ResourceBundle schema, List<Animation> animations, VariableMap context) {
        super(schema, animations, context);
    }

    @Override
    public void init(Mascot mascot) throws VariableException {
        super.init(mascot);
        if (this.getBornInterval() < 1) {
            throw new VariableException("BornInterval must be positive");
        }
        this.scaling = Double.parseDouble(Main.getInstance().getProperties().getProperty("Scaling", "1.0"));
    }

    @Override
    protected void tick() throws LostGroundException, VariableException {
        super.tick();
        if (this.getTime() % this.getBornInterval() == 0 && (this.getBornTransient() ? Boolean.parseBoolean(Main.getInstance().getProperties().getProperty("Transients", "true")) : Boolean.parseBoolean(Main.getInstance().getProperties().getProperty("Breeding", "true")))) {
            this.breed();
        }
    }

    private void breed() throws VariableException {
        String childType = Main.getInstance().getConfiguration(this.getBornMascot()) != null ? this.getBornMascot() : this.getMascot().getImageSet();
        Mascot mascot = new Mascot(childType);
        log.log(Level.INFO, "Breed Mascot ({0},{1},{2})", new Object[]{this.getMascot(), this, mascot});
        if (this.getMascot().isLookRight()) {
            mascot.setAnchor(new Point(this.getMascot().getAnchor().x - (int)Math.round((double)this.getBornX() * this.scaling), this.getMascot().getAnchor().y + (int)Math.round((double)this.getBornY() * this.scaling)));
        } else {
            mascot.setAnchor(new Point(this.getMascot().getAnchor().x + (int)Math.round((double)this.getBornX() * this.scaling), this.getMascot().getAnchor().y + (int)Math.round((double)this.getBornY() * this.scaling)));
        }
        mascot.setLookRight(this.getMascot().isLookRight());
        try {
            mascot.setBehavior(Main.getInstance().getConfiguration(childType).buildBehavior(this.getBornBehaviour(), this.getMascot()));
            this.getMascot().getManager().add(mascot);
        }
        catch (BehaviorInstantiationException e) {
            log.log(Level.SEVERE, "Fatal Exception", e);
            Main.showError(Main.getInstance().getLanguageBundle().getString("FailedCreateNewShimejiErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
            mascot.dispose();
        }
        catch (CantBeAliveException e) {
            log.log(Level.SEVERE, "Fatal Exception", e);
            Main.showError(Main.getInstance().getLanguageBundle().getString("FailedCreateNewShimejiErrorMessage") + "\n" + e.getMessage() + "\n" + Main.getInstance().getLanguageBundle().getString("SeeLogForDetails"));
            mascot.dispose();
        }
    }

    private int getBornX() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_BORNX), Number.class, 0)).intValue();
    }

    private int getBornY() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_BORNY), Number.class, 0)).intValue();
    }

    private String getBornBehaviour() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_BORNBEHAVIOUR), String.class, "");
    }

    private String getBornMascot() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_BORNMASCOT), String.class, "");
    }

    private boolean getBornTransient() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_BORNTRANSIENT), Boolean.class, false);
    }

    private int getBornInterval() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_BORNINTERVAL), Number.class, 1)).intValue();
    }
}

