/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Manager;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.NativeFactory;
import com.group_finity.mascot.Platform;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.image.ImagePairs;
import com.group_finity.mascot.imagesetchooser.ImageSetChooser;
import com.group_finity.mascot.sound.Sounds;
import com.group_finity.mascot.win.WindowsInteractiveWindowForm;
import com.joconner.i18n.Utf8ResourceBundleControl;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.metal.MetalTheme;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class.getName());
    static final String BEHAVIOR_GATHER = "ChaseMouse";
    private final Manager manager = new Manager();
    private ArrayList<String> imageSets = new ArrayList();
    private Hashtable<String, Configuration> configurations = new Hashtable();
    private Hashtable<String, ArrayList<String>> childImageSets = new Hashtable();
    private static Main instance;
    private Properties properties = new Properties();
    private Platform platform;
    private ResourceBundle languageBundle;
    private JDialog form;
    private static JFrame frame;

    public static Main getInstance() {
        return instance;
    }

    public static void showError(String message) {
        JOptionPane.showMessageDialog(frame, message, "Error", 0);
    }

    public static void main(String[] args) {
        try {
            Main.getInstance().run();
        }
        catch (OutOfMemoryError err) {
            log.log(Level.SEVERE, "Out of Memory Exception.  There are probably have too many Shimeji mascots in the image folder for your computer to handle.  Select fewer image sets or move some to the img/unused folder and try again.", err);
            Main.showError("Out of Memory.  There are probably have too many \nShimeji mascots for your computer to handle.\nSelect fewer image sets or move some to the \nimg/unused folder and try again.");
            System.exit(0);
        }
    }

    public void run() {
        this.platform = !System.getProperty("sun.arch.data.model").equals("64") ? Platform.x86 : Platform.x86_64;
        this.properties = new Properties();
        try {
            FileInputStream input = new FileInputStream("./conf/settings.properties");
            this.properties.load(input);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Utf8ResourceBundleControl utf8Control = new Utf8ResourceBundleControl(false);
            this.languageBundle = ResourceBundle.getBundle("language", Locale.forLanguageTag(this.properties.getProperty("Language", "en-GB")), utf8Control);
        }
        catch (Exception ex) {
            Main.showError("The default language file could not be loaded. Ensure that you have the latest shimeji language.properties in your conf directory.");
            this.exit();
        }
        try {
            NimRODLookAndFeel lookAndFeel = new NimRODLookAndFeel();
            NimRODTheme theme = null;
            try {
                if (new File("./conf/theme.properties").isFile()) {
                    theme = new NimRODTheme("./conf/theme.properties");
                }
            }
            catch (Exception exc) {
                theme = null;
            }
            if (theme == null) {
                theme = new NimRODTheme();
                theme.setPrimary1(Color.decode("#1EA6EB"));
                theme.setPrimary2(Color.decode("#28B0F5"));
                theme.setPrimary3(Color.decode("#32BAFF"));
                theme.setSecondary1(Color.decode("#BCBCBE"));
                theme.setSecondary2(Color.decode("#C6C6C8"));
                theme.setSecondary3(Color.decode("#D0D0D2"));
                theme.setMenuOpacity(255);
                theme.setFrameOpacity(255);
            }
            if (!this.properties.containsKey("MenuDPI")) {
                this.properties.setProperty("MenuDPI", Math.max(Toolkit.getDefaultToolkit().getScreenResolution(), 96) + "");
                this.updateConfigFile();
            }
            float menuScaling = Float.parseFloat(this.properties.getProperty("MenuDPI", "96")) / 96.0f;
            Font font = theme.getUserTextFont().deriveFont((float)theme.getUserTextFont().getSize() * menuScaling);
            theme.setFont(font);
            NimRODLookAndFeel.setCurrentTheme((MetalTheme)theme);
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            lookAndFeel.initialize();
            UIManager.setLookAndFeel((LookAndFeel)lookAndFeel);
        }
        catch (Exception ex) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex1) {
                log.log(Level.SEVERE, "Look & Feel unsupported.", ex1);
                this.exit();
            }
        }
        if (!Boolean.parseBoolean(this.properties.getProperty("AlwaysShowShimejiChooser", "false"))) {
            for (String set : this.properties.getProperty("ActiveShimeji", "").split("/")) {
                if (set.trim().isEmpty()) continue;
                this.imageSets.add(set.trim());
            }
        }
        if (this.imageSets.isEmpty()) {
            this.imageSets = new ImageSetChooser((Frame)frame, true).display();
            if (this.imageSets == null) {
                this.exit();
            }
        }
        for (int index = 0; index < this.imageSets.size(); ++index) {
            if (this.loadConfiguration(this.imageSets.get(index))) continue;
            this.configurations.remove(this.imageSets.get(index));
            this.imageSets.remove(this.imageSets.get(index));
            --index;
        }
        if (this.imageSets.isEmpty()) {
            this.exit();
        }
        this.createTrayIcon();
        for (String imageSet : this.imageSets) {
            this.createMascot(imageSet);
        }
        this.getManager().start();
    }

    private boolean loadConfiguration(String imageSet) {
        try {
            String filePath = "./conf/";
            String actionsFile = filePath + "actions.xml";
            if (new File(filePath + "\u52d5\u4f5c.xml").exists()) {
                actionsFile = filePath + "\u52d5\u4f5c.xml";
            }
            if (new File((filePath = "./conf/" + imageSet + "/") + "actions.xml").exists()) {
                actionsFile = filePath + "actions.xml";
            }
            if (new File(filePath + "\u52d5\u4f5c.xml").exists()) {
                actionsFile = filePath + "\u52d5\u4f5c.xml";
            }
            if (new File(filePath + "\u00d5\u00ef\u00f2\u00f5\u00a2\u00a3.xml").exists()) {
                actionsFile = filePath + "\u00d5\u00ef\u00f2\u00f5\u00a2\u00a3.xml";
            }
            if (new File(filePath + "\u00a6-\u00ba@.xml").exists()) {
                actionsFile = filePath + "\u00a6-\u00ba@.xml";
            }
            if (new File(filePath + "\u00f4\u00ab\u00ec\u00fd.xml").exists()) {
                actionsFile = filePath + "\u00f4\u00ab\u00ec\u00fd.xml";
            }
            if (new File(filePath + "one.xml").exists()) {
                actionsFile = filePath + "one.xml";
            }
            if (new File(filePath + "1.xml").exists()) {
                actionsFile = filePath + "1.xml";
            }
            if (new File((filePath = "./img/" + imageSet + "/conf/") + "actions.xml").exists()) {
                actionsFile = filePath + "actions.xml";
            }
            if (new File(filePath + "\u52d5\u4f5c.xml").exists()) {
                actionsFile = filePath + "\u52d5\u4f5c.xml";
            }
            if (new File(filePath + "\u00d5\u00ef\u00f2\u00f5\u00a2\u00a3.xml").exists()) {
                actionsFile = filePath + "\u00d5\u00ef\u00f2\u00f5\u00a2\u00a3.xml";
            }
            if (new File(filePath + "\u00a6-\u00ba@.xml").exists()) {
                actionsFile = filePath + "\u00a6-\u00ba@.xml";
            }
            if (new File(filePath + "\u00f4\u00ab\u00ec\u00fd.xml").exists()) {
                actionsFile = filePath + "\u00f4\u00ab\u00ec\u00fd.xml";
            }
            if (new File(filePath + "one.xml").exists()) {
                actionsFile = filePath + "one.xml";
            }
            if (new File(filePath + "1.xml").exists()) {
                actionsFile = filePath + "1.xml";
            }
            log.log(Level.INFO, imageSet + " Read Action File ({0})", actionsFile);
            Document actions = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(new File(actionsFile)));
            Configuration configuration = new Configuration();
            configuration.load(new Entry(actions.getDocumentElement()), imageSet);
            filePath = "./conf/";
            String behaviorsFile = filePath + "behaviors.xml";
            if (new File(filePath + "\u884c\u52d5.xml").exists()) {
                behaviorsFile = filePath + "\u884c\u52d5.xml";
            }
            if (new File((filePath = "./conf/" + imageSet + "/") + "behaviors.xml").exists()) {
                behaviorsFile = filePath + "behaviors.xml";
            }
            if (new File(filePath + "behavior.xml").exists()) {
                behaviorsFile = filePath + "behavior.xml";
            }
            if (new File(filePath + "\u884c\u52d5.xml").exists()) {
                behaviorsFile = filePath + "\u884c\u52d5.xml";
            }
            if (new File(filePath + "\u00de\u00ed\u00ee\u00d5\u00ef\u00f2.xml").exists()) {
                behaviorsFile = filePath + "\u00de\u00ed\u00ee\u00d5\u00ef\u00f2.xml";
            }
            if (new File(filePath + "\u00aa\u00b5\u00a6-.xml").exists()) {
                behaviorsFile = filePath + "\u00aa\u00b5\u00a6-.xml";
            }
            if (new File(filePath + "\u00ecs\u00f4\u00ab.xml").exists()) {
                behaviorsFile = filePath + "\u00ecs\u00f4\u00ab.xml";
            }
            if (new File(filePath + "two.xml").exists()) {
                behaviorsFile = filePath + "two.xml";
            }
            if (new File(filePath + "2.xml").exists()) {
                behaviorsFile = filePath + "2.xml";
            }
            if (new File((filePath = "./img/" + imageSet + "/conf/") + "behaviors.xml").exists()) {
                behaviorsFile = filePath + "behaviors.xml";
            }
            if (new File(filePath + "behavior.xml").exists()) {
                behaviorsFile = filePath + "behavior.xml";
            }
            if (new File(filePath + "\u884c\u52d5.xml").exists()) {
                behaviorsFile = filePath + "\u884c\u52d5.xml";
            }
            if (new File(filePath + "\u00de\u00ed\u00ee\u00d5\u00ef\u00f2.xml").exists()) {
                behaviorsFile = filePath + "\u00de\u00ed\u00ee\u00d5\u00ef\u00f2.xml";
            }
            if (new File(filePath + "\u00aa\u00b5\u00a6-.xml").exists()) {
                behaviorsFile = filePath + "\u00aa\u00b5\u00a6-.xml";
            }
            if (new File(filePath + "\u00ecs\u00f4\u00ab.xml").exists()) {
                behaviorsFile = filePath + "\u00ecs\u00f4\u00ab.xml";
            }
            if (new File(filePath + "two.xml").exists()) {
                behaviorsFile = filePath + "two.xml";
            }
            if (new File(filePath + "2.xml").exists()) {
                behaviorsFile = filePath + "2.xml";
            }
            log.log(Level.INFO, imageSet + " Read Behavior File ({0})", behaviorsFile);
            Document behaviors = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(new File(behaviorsFile)));
            configuration.load(new Entry(behaviors.getDocumentElement()), imageSet);
            configuration.validate();
            this.configurations.put(imageSet, configuration);
            ArrayList<String> childMascots = new ArrayList<String>();
            for (Entry list : new Entry(actions.getDocumentElement()).selectChildren("ActionList")) {
                for (Entry node : list.selectChildren("Action")) {
                    String set;
                    if (node.getAttributes().containsKey("BornMascot")) {
                        set = node.getAttribute("BornMascot");
                        if (!childMascots.contains(set)) {
                            childMascots.add(set);
                        }
                        if (!this.configurations.containsKey(set)) {
                            this.loadConfiguration(set);
                        }
                    }
                    if (!node.getAttributes().containsKey("TransformMascot")) continue;
                    set = node.getAttribute("TransformMascot");
                    if (!childMascots.contains(set)) {
                        childMascots.add(set);
                    }
                    if (this.configurations.containsKey(set)) continue;
                    this.loadConfiguration(set);
                }
            }
            this.childImageSets.put(imageSet, childMascots);
            return true;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError(this.languageBundle.getString("FailedLoadConfigErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
        }
        catch (SAXException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError(this.languageBundle.getString("FailedLoadConfigErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
        }
        catch (ParserConfigurationException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError(this.languageBundle.getString("FailedLoadConfigErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
        }
        catch (ConfigurationException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError(this.languageBundle.getString("FailedLoadConfigErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError(this.languageBundle.getString("FailedLoadConfigErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
        }
        return false;
    }

    private void createTrayIcon() {
        log.log(Level.INFO, "create a tray icon");
        BufferedImage image = null;
        try {
            image = ImageIO.read(Main.class.getResource("/icon.png"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to create tray icon", e);
            Main.showError(this.languageBundle.getString("FailedDisplaySystemTrayErrorMessage") + "\n" + this.languageBundle.getString("SeeLogForDetails"));
        }
        finally {
            if (image == null) {
                image = new BufferedImage(16, 16, 1);
            }
        }
        try {
            final TrayIcon icon = new TrayIcon(image, this.languageBundle.getString("ShimejiEE"));
            icon.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent event) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        if (Main.this.form != null) {
                            Main.this.form.dispose();
                        }
                        Main.this.form = new JDialog((Frame)frame, false);
                        final JPanel panel = new JPanel();
                        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
                        Main.this.form.add(panel);
                        JButton btnCallShimeji = new JButton(Main.this.languageBundle.getString("CallShimeji"));
                        btnCallShimeji.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                Main.this.createMascot();
                                Main.this.form.dispose();
                            }
                        });
                        JButton btnFollowCursor = new JButton(Main.this.languageBundle.getString("FollowCursor"));
                        btnFollowCursor.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                Main.this.getManager().setBehaviorAll(Main.BEHAVIOR_GATHER);
                                Main.this.form.dispose();
                            }
                        });
                        JButton btnReduceToOne = new JButton(Main.this.languageBundle.getString("ReduceToOne"));
                        btnReduceToOne.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                Main.this.getManager().remainOne();
                                Main.this.form.dispose();
                            }
                        });
                        JButton btnRestoreWindows = new JButton(Main.this.languageBundle.getString("RestoreWindows"));
                        btnRestoreWindows.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                NativeFactory.getInstance().getEnvironment().restoreIE();
                                Main.this.form.dispose();
                            }
                        });
                        final JButton btnAllowedBehaviours = new JButton(Main.this.languageBundle.getString("AllowedBehaviours"));
                        btnAllowedBehaviours.addMouseListener(new MouseListener(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                            }

                            @Override
                            public void mousePressed(MouseEvent e) {
                            }

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                btnAllowedBehaviours.setEnabled(true);
                            }

                            @Override
                            public void mouseEntered(MouseEvent e) {
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                            }
                        });
                        btnAllowedBehaviours.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                final JCheckBoxMenuItem breedingMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("BreedingCloning"), Boolean.parseBoolean(Main.this.properties.getProperty("Breeding", "true")));
                                breedingMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        breedingMenu.setState(Main.this.toggleBooleanSetting("Breeding", true));
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                final JCheckBoxMenuItem transientMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("BreedingTransient"), Boolean.parseBoolean(Main.this.properties.getProperty("Transients", "true")));
                                transientMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        transientMenu.setState(Main.this.toggleBooleanSetting("Transients", true));
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                final JCheckBoxMenuItem transformationMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("Transformation"), Boolean.parseBoolean(Main.this.properties.getProperty("Transformation", "true")));
                                transformationMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        transformationMenu.setState(Main.this.toggleBooleanSetting("Transformation", true));
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                final JCheckBoxMenuItem throwingMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("ThrowingWindows"), Boolean.parseBoolean(Main.this.properties.getProperty("Throwing", "true")));
                                throwingMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        throwingMenu.setState(Main.this.toggleBooleanSetting("Throwing", true));
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                final JCheckBoxMenuItem soundsMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("SoundEffects"), Boolean.parseBoolean(Main.this.properties.getProperty("Sounds", "true")));
                                soundsMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        boolean result = Main.this.toggleBooleanSetting("Sounds", true);
                                        soundsMenu.setState(result);
                                        Sounds.setMuted(!result);
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                final JCheckBoxMenuItem multiscreenMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("Multiscreen"), Boolean.parseBoolean(Main.this.properties.getProperty("Multiscreen", "true")));
                                multiscreenMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        multiscreenMenu.setState(Main.this.toggleBooleanSetting("Multiscreen", true));
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                JPopupMenu behaviourPopup = new JPopupMenu();
                                behaviourPopup.add(breedingMenu);
                                behaviourPopup.add(transientMenu);
                                behaviourPopup.add(transformationMenu);
                                behaviourPopup.add(throwingMenu);
                                behaviourPopup.add(soundsMenu);
                                behaviourPopup.add(multiscreenMenu);
                                behaviourPopup.addPopupMenuListener(new PopupMenuListener(){

                                    @Override
                                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                                    }

                                    @Override
                                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                                        if (panel.getMousePosition() != null) {
                                            btnAllowedBehaviours.setEnabled(panel.getMousePosition().x <= btnAllowedBehaviours.getX() || panel.getMousePosition().x >= btnAllowedBehaviours.getX() + btnAllowedBehaviours.getWidth() || panel.getMousePosition().y <= btnAllowedBehaviours.getY() || panel.getMousePosition().y >= btnAllowedBehaviours.getY() + btnAllowedBehaviours.getHeight());
                                        } else {
                                            btnAllowedBehaviours.setEnabled(true);
                                        }
                                    }

                                    @Override
                                    public void popupMenuCanceled(PopupMenuEvent e) {
                                    }
                                });
                                behaviourPopup.show(btnAllowedBehaviours, 0, btnAllowedBehaviours.getHeight());
                                btnAllowedBehaviours.requestFocusInWindow();
                            }
                        });
                        final JButton btnSettings = new JButton(Main.this.languageBundle.getString("Settings"));
                        btnSettings.addMouseListener(new MouseListener(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                            }

                            @Override
                            public void mousePressed(MouseEvent e) {
                            }

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                btnSettings.setEnabled(true);
                            }

                            @Override
                            public void mouseEntered(MouseEvent e) {
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                            }
                        });
                        btnSettings.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JMenuItem chooseShimejiMenu = new JMenuItem(Main.this.languageBundle.getString("ChooseShimeji"));
                                chooseShimejiMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.setActiveImageSets(new ImageSetChooser((Frame)frame, true).display());
                                    }
                                });
                                JMenuItem interactiveMenu = new JMenuItem(Main.this.languageBundle.getString("ChooseInteractiveWindows"));
                                interactiveMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        new WindowsInteractiveWindowForm((Frame)frame, true).display();
                                        NativeFactory.getInstance().getEnvironment().refreshCache();
                                    }
                                });
                                final JCheckBoxMenuItem shimejiChooserMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("AlwaysShowShimejiChooser"), Boolean.parseBoolean(Main.this.properties.getProperty("AlwaysShowShimejiChooser", "false")));
                                shimejiChooserMenu.addItemListener(new ItemListener(){

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        shimejiChooserMenu.setState(Main.this.toggleBooleanSetting("AlwaysShowShimejiChooser", false));
                                        Main.this.updateConfigFile();
                                        btnAllowedBehaviours.setEnabled(true);
                                    }
                                });
                                JMenu scalingMenu = new JMenu(Main.this.languageBundle.getString("Scaling"));
                                final JCheckBoxMenuItem filterMenu = new JCheckBoxMenuItem(Main.this.languageBundle.getString("Filter"), Boolean.parseBoolean(Main.this.properties.getProperty("Filter", "false")));
                                filterMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        filterMenu.setState(Main.this.toggleBooleanSetting("Filter", false));
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                JCheckBoxMenuItem scaling1x = new JCheckBoxMenuItem("1x", Integer.parseInt(Main.this.properties.getProperty("Scaling", "1")) == 1);
                                scaling1x.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.properties.setProperty("Scaling", "1");
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                JCheckBoxMenuItem scaling2x = new JCheckBoxMenuItem("2x", Integer.parseInt(Main.this.properties.getProperty("Scaling", "1")) == 2);
                                scaling2x.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.properties.setProperty("Scaling", "2");
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                JCheckBoxMenuItem scaling3x = new JCheckBoxMenuItem("3x", Integer.parseInt(Main.this.properties.getProperty("Scaling", "1")) == 3);
                                scaling3x.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.properties.setProperty("Scaling", "3");
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                JCheckBoxMenuItem scaling4x = new JCheckBoxMenuItem("4x", Integer.parseInt(Main.this.properties.getProperty("Scaling", "1")) == 4);
                                scaling4x.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.properties.setProperty("Scaling", "4");
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                JCheckBoxMenuItem scaling6x = new JCheckBoxMenuItem("6x", Integer.parseInt(Main.this.properties.getProperty("Scaling", "1")) == 6);
                                scaling6x.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.properties.setProperty("Scaling", "6");
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                JCheckBoxMenuItem scaling8x = new JCheckBoxMenuItem("8x", Integer.parseInt(Main.this.properties.getProperty("Scaling", "1")) == 8);
                                scaling8x.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.properties.setProperty("Scaling", "8");
                                        Main.this.updateConfigFile();
                                        boolean isExit = Main.this.getManager().isExitOnLastRemoved();
                                        Main.this.getManager().setExitOnLastRemoved(false);
                                        Main.this.getManager().disposeAll();
                                        ImagePairs.clear();
                                        Main.this.configurations.clear();
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.loadConfiguration(imageSet);
                                        }
                                        for (String imageSet : Main.this.imageSets) {
                                            Main.this.createMascot(imageSet);
                                        }
                                        Main.this.getManager().setExitOnLastRemoved(isExit);
                                    }
                                });
                                scalingMenu.add(filterMenu);
                                scalingMenu.add(new JSeparator());
                                scalingMenu.add(scaling1x);
                                scalingMenu.add(scaling2x);
                                scalingMenu.add(scaling3x);
                                scalingMenu.add(scaling4x);
                                scalingMenu.add(scaling6x);
                                scalingMenu.add(scaling8x);
                                JPopupMenu settingsPopup = new JPopupMenu();
                                settingsPopup.add(chooseShimejiMenu);
                                settingsPopup.add(interactiveMenu);
                                settingsPopup.add(new JSeparator());
                                settingsPopup.add(shimejiChooserMenu);
                                settingsPopup.add(new JSeparator());
                                settingsPopup.add(scalingMenu);
                                settingsPopup.addPopupMenuListener(new PopupMenuListener(){

                                    @Override
                                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                                    }

                                    @Override
                                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                                        if (panel.getMousePosition() != null) {
                                            btnSettings.setEnabled(panel.getMousePosition().x <= btnSettings.getX() || panel.getMousePosition().x >= btnSettings.getX() + btnSettings.getWidth() || panel.getMousePosition().y <= btnSettings.getY() || panel.getMousePosition().y >= btnSettings.getY() + btnSettings.getHeight());
                                        } else {
                                            btnSettings.setEnabled(true);
                                        }
                                    }

                                    @Override
                                    public void popupMenuCanceled(PopupMenuEvent e) {
                                    }
                                });
                                settingsPopup.show(btnSettings, 0, btnSettings.getHeight());
                                btnSettings.requestFocusInWindow();
                            }
                        });
                        final JButton btnLanguage = new JButton(Main.this.languageBundle.getString("Language"));
                        btnLanguage.addMouseListener(new MouseListener(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                            }

                            @Override
                            public void mousePressed(MouseEvent e) {
                            }

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                btnLanguage.setEnabled(true);
                            }

                            @Override
                            public void mouseEntered(MouseEvent e) {
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                            }
                        });
                        btnLanguage.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JMenuItem englishMenu = new JMenuItem("English");
                                englishMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("en-GB");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem catalanMenu = new JMenuItem("Catal\u00e0");
                                catalanMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("ca-ES");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem germanMenu = new JMenuItem("Deutsch");
                                germanMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("de-DE");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem spanishMenu = new JMenuItem("Espa\u00f1ol");
                                spanishMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("es-ES");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem frenchMenu = new JMenuItem("Fran\u00e7ais");
                                frenchMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("fr-FR");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem croatianMenu = new JMenuItem("Hrvatski");
                                croatianMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("hr-HR");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem italianMenu = new JMenuItem("Italiano");
                                italianMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("it-IT");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem dutchMenu = new JMenuItem("Nederlands");
                                dutchMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("nl-NL");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem polishMenu = new JMenuItem("Polski");
                                polishMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("pl-PL");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem brazilianPortugueseMenu = new JMenuItem("Portugu\u00eas Brasileiro");
                                brazilianPortugueseMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("pt-BR");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem portugueseMenu = new JMenuItem("Portugu\u00eas");
                                portugueseMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("pt-PT");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem russianMenu = new JMenuItem("\u0440\u0443\u0301\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u0301\u043a");
                                russianMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("ru-RU");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem romanianMenu = new JMenuItem("Rom\u00e2n\u0103");
                                romanianMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("ro-RO");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem serbianMenu = new JMenuItem("Srpski");
                                serbianMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("sr-RS");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem finnishMenu = new JMenuItem("Suomi");
                                finnishMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("fi-FI");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem vietnameseMenu = new JMenuItem("ti\u1ebfng Vi\u1ec7t");
                                vietnameseMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("vi-VN");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem chineseMenu = new JMenuItem("\u7b80\u4f53\u4e2d\u6587");
                                chineseMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("zh-CN");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem koreanMenu = new JMenuItem("\ud55c\uad6d\uc5b4");
                                koreanMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("ko-KR");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JMenuItem japaneseMenu = new JMenuItem("\u65e5\u672c\u8a9e");
                                japaneseMenu.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        Main.this.form.dispose();
                                        Main.this.updateLanguage("ja-JP");
                                        Main.this.updateConfigFile();
                                    }
                                });
                                JPopupMenu languagePopup = new JPopupMenu();
                                languagePopup.add(englishMenu);
                                languagePopup.addSeparator();
                                languagePopup.add(catalanMenu);
                                languagePopup.add(germanMenu);
                                languagePopup.add(spanishMenu);
                                languagePopup.add(frenchMenu);
                                languagePopup.add(croatianMenu);
                                languagePopup.add(italianMenu);
                                languagePopup.add(dutchMenu);
                                languagePopup.add(polishMenu);
                                languagePopup.add(portugueseMenu);
                                languagePopup.add(brazilianPortugueseMenu);
                                languagePopup.add(russianMenu);
                                languagePopup.add(romanianMenu);
                                languagePopup.add(serbianMenu);
                                languagePopup.add(finnishMenu);
                                languagePopup.add(vietnameseMenu);
                                languagePopup.add(chineseMenu);
                                languagePopup.add(koreanMenu);
                                languagePopup.add(japaneseMenu);
                                languagePopup.addPopupMenuListener(new PopupMenuListener(){

                                    @Override
                                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                                    }

                                    @Override
                                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                                        if (panel.getMousePosition() != null) {
                                            btnLanguage.setEnabled(panel.getMousePosition().x <= btnLanguage.getX() || panel.getMousePosition().x >= btnLanguage.getX() + btnLanguage.getWidth() || panel.getMousePosition().y <= btnLanguage.getY() || panel.getMousePosition().y >= btnLanguage.getY() + btnLanguage.getHeight());
                                        } else {
                                            btnLanguage.setEnabled(true);
                                        }
                                    }

                                    @Override
                                    public void popupMenuCanceled(PopupMenuEvent e) {
                                    }
                                });
                                languagePopup.show(btnLanguage, 0, btnLanguage.getHeight());
                                btnLanguage.requestFocusInWindow();
                            }
                        });
                        JButton btnDismissAll = new JButton(Main.this.languageBundle.getString("DismissAll"));
                        btnDismissAll.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Main.this.exit();
                            }
                        });
                        float scaling = Float.parseFloat(Main.this.properties.getProperty("MenuDPI", "96")) / 96.0f;
                        panel.setLayout(new GridBagLayout());
                        GridBagConstraints gridBag = new GridBagConstraints();
                        gridBag.fill = 2;
                        gridBag.gridx = 0;
                        gridBag.gridy = 0;
                        panel.add((Component)btnCallShimeji, gridBag);
                        gridBag.insets = new Insets((int)(5.0f * scaling), 0, 0, 0);
                        ++gridBag.gridy;
                        panel.add((Component)btnFollowCursor, gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)btnReduceToOne, gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)btnRestoreWindows, gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)new JSeparator(), gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)btnAllowedBehaviours, gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)btnSettings, gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)btnLanguage, gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)new JSeparator(), gridBag);
                        ++gridBag.gridy;
                        panel.add((Component)btnDismissAll, gridBag);
                        Main.this.form.setIconImage(icon.getImage());
                        Main.this.form.setTitle(Main.this.languageBundle.getString("ShimejiEE"));
                        Main.this.form.setDefaultCloseOperation(2);
                        Main.this.form.setAlwaysOnTop(true);
                        FontMetrics metrics = btnCallShimeji.getFontMetrics(btnCallShimeji.getFont());
                        int width = metrics.stringWidth(btnCallShimeji.getText());
                        width = Math.max(metrics.stringWidth(btnFollowCursor.getText()), width);
                        width = Math.max(metrics.stringWidth(btnReduceToOne.getText()), width);
                        width = Math.max(metrics.stringWidth(btnRestoreWindows.getText()), width);
                        width = Math.max(metrics.stringWidth(btnAllowedBehaviours.getText()), width);
                        width = Math.max(metrics.stringWidth(btnSettings.getText()), width);
                        width = Math.max(metrics.stringWidth(btnLanguage.getText()), width);
                        width = Math.max(metrics.stringWidth(btnDismissAll.getText()), width);
                        panel.setPreferredSize(new Dimension(width + 64, (int)(24.0f * scaling) + (int)(45.0f * scaling) + 8 * metrics.getHeight() + 84));
                        Main.this.form.pack();
                        Main.this.form.setLocation(event.getPoint().x - Main.this.form.getWidth(), event.getPoint().y - Main.this.form.getHeight());
                        Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                        if ((double)Main.this.form.getX() < screen.getX()) {
                            Main.this.form.setLocation(event.getPoint().x, Main.this.form.getY());
                        }
                        if ((double)Main.this.form.getY() < screen.getY()) {
                            Main.this.form.setLocation(Main.this.form.getX(), event.getPoint().y);
                        }
                        Main.this.form.setVisible(true);
                        Main.this.form.setMinimumSize(Main.this.form.getSize());
                    } else if (event.getButton() == 1) {
                        Main.this.createMascot();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            SystemTray.getSystemTray().add(icon);
        }
        catch (AWTException e) {
            log.log(Level.SEVERE, "Failed to create tray icon", e);
            Main.showError(this.languageBundle.getString("FailedDisplaySystemTrayErrorMessage") + "\n" + this.languageBundle.getString("SeeLogForDetails"));
            this.exit();
        }
    }

    public void createMascot() {
        int length = this.imageSets.size();
        int random = (int)((double)length * Math.random());
        this.createMascot(this.imageSets.get(random));
    }

    public void createMascot(String imageSet) {
        log.log(Level.INFO, "create a mascot");
        Mascot mascot = new Mascot(imageSet);
        mascot.setAnchor(new Point(-4000, -4000));
        mascot.setLookRight(Math.random() < 0.5);
        try {
            mascot.setBehavior(this.getConfiguration(imageSet).buildBehavior(null, mascot));
            this.getManager().add(mascot);
        }
        catch (BehaviorInstantiationException e) {
            log.log(Level.SEVERE, "Failed to initialize the first action", e);
            Main.showError(this.languageBundle.getString("FailedInitialiseFirstActionErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
            mascot.dispose();
        }
        catch (CantBeAliveException e) {
            log.log(Level.SEVERE, "Fatal Error", e);
            Main.showError(this.languageBundle.getString("FailedInitialiseFirstActionErrorMessage") + "\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
            mascot.dispose();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, imageSet + " fatal error, can not be started.", e);
            Main.showError(this.languageBundle.getString("CouldNotCreateShimejiErrorMessage") + imageSet + ".\n" + e.getMessage() + "\n" + this.languageBundle.getString("SeeLogForDetails"));
            mascot.dispose();
        }
    }

    private void refreshLanguage() {
        Utf8ResourceBundleControl utf8Control = new Utf8ResourceBundleControl(false);
        this.languageBundle = ResourceBundle.getBundle("language", Locale.forLanguageTag(this.properties.getProperty("Language", "en-GB")), utf8Control);
        boolean isExit = this.getManager().isExitOnLastRemoved();
        this.getManager().setExitOnLastRemoved(false);
        this.getManager().disposeAll();
        for (String imageSet : this.imageSets) {
            this.loadConfiguration(imageSet);
        }
        for (String imageSet : this.imageSets) {
            this.createMascot(imageSet);
        }
        this.getManager().setExitOnLastRemoved(isExit);
    }

    private void updateLanguage(String language) {
        if (!this.properties.getProperty("Language", "en-GB").equals(language)) {
            this.properties.setProperty("Language", language);
            this.refreshLanguage();
        }
    }

    private boolean toggleBooleanSetting(String propertyName, boolean defaultValue) {
        if (Boolean.parseBoolean(this.properties.getProperty(propertyName, defaultValue + ""))) {
            this.properties.setProperty(propertyName, "false");
            return false;
        }
        this.properties.setProperty(propertyName, "true");
        return true;
    }

    private void updateConfigFile() {
        try {
            FileOutputStream output = new FileOutputStream("./conf/settings.properties");
            try {
                this.properties.store(output, "Shimeji-ee Configuration Options");
            }
            finally {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setActiveImageSets(ArrayList<String> newImageSets) {
        if (newImageSets == null) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>(this.imageSets);
        toRemove.removeAll(newImageSets);
        ArrayList<String> toAdd = new ArrayList<String>();
        ArrayList<String> toRetain = new ArrayList<String>();
        for (String set : newImageSets) {
            if (!this.imageSets.contains(set)) {
                toAdd.add(set);
            }
            if (!toRetain.contains(set)) {
                toRetain.add(set);
            }
            this.populateArrayListWithChildSets(set, toRetain);
        }
        boolean isExit = this.getManager().isExitOnLastRemoved();
        this.getManager().setExitOnLastRemoved(false);
        for (String r : toRemove) {
            this.removeLoadedImageSet(r, toRetain);
        }
        for (String a : toAdd) {
            this.addImageSet(a);
        }
        this.getManager().setExitOnLastRemoved(isExit);
    }

    private void populateArrayListWithChildSets(String imageSet, ArrayList<String> childList) {
        if (this.childImageSets.containsKey(imageSet)) {
            for (String set : this.childImageSets.get(imageSet)) {
                if (childList.contains(set)) continue;
                this.populateArrayListWithChildSets(set, childList);
                childList.add(set);
            }
        }
    }

    private void removeLoadedImageSet(String imageSet, ArrayList<String> setsToIgnore) {
        if (this.childImageSets.containsKey(imageSet)) {
            for (String set : this.childImageSets.get(imageSet)) {
                if (setsToIgnore.contains(set)) continue;
                setsToIgnore.add(set);
                this.imageSets.remove(imageSet);
                this.getManager().remainNone(imageSet);
                this.configurations.remove(imageSet);
                ImagePairs.removeAll(imageSet);
                this.removeLoadedImageSet(set, setsToIgnore);
            }
        }
        if (!setsToIgnore.contains(imageSet)) {
            this.imageSets.remove(imageSet);
            this.getManager().remainNone(imageSet);
            this.configurations.remove(imageSet);
            ImagePairs.removeAll(imageSet);
        }
    }

    private void addImageSet(String imageSet) {
        if (this.configurations.containsKey(imageSet)) {
            this.imageSets.add(imageSet);
            this.createMascot(imageSet);
        } else if (this.loadConfiguration(imageSet)) {
            this.imageSets.add(imageSet);
            this.createMascot(imageSet);
        } else {
            this.configurations.remove(imageSet);
        }
    }

    public Configuration getConfiguration(String imageSet) {
        return this.configurations.get(imageSet);
    }

    private Manager getManager() {
        return this.manager;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ResourceBundle getLanguageBundle() {
        return this.languageBundle;
    }

    public void exit() {
        this.getManager().disposeAll();
        this.getManager().stop();
        System.exit(0);
    }

    static {
        try {
            LogManager.getLogManager().readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError err) {
            log.log(Level.SEVERE, "Out of Memory Exception.  There are probably have too many Shimeji mascots in the image folder for your computer to handle.  Select fewer image sets or move some to the img/unused folder and try again.", err);
            Main.showError("Out of Memory.  There are probably have too many \nShimeji mascots for your computer to handle.\nSelect fewer image sets or move some to the \nimg/unused folder and try again.");
            System.exit(0);
        }
        instance = new Main();
        frame = new JFrame();
    }
}

