/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.win;

import com.group_finity.mascot.environment.Area;
import com.group_finity.mascot.environment.Environment;
import com.group_finity.mascot.win.jna.Gdi32;
import com.group_finity.mascot.win.jna.RECT;
import com.group_finity.mascot.win.jna.User32;
import com.sun.jna.Pointer;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

class WindowsEnvironment
extends Environment {
    private static HashMap<Pointer, Boolean> ieCache = new LinkedHashMap<Pointer, Boolean>();
    static int f;
    public static Area workArea;
    public static Area activeIE;

    WindowsEnvironment() {
    }

    private static Rectangle getWorkAreaRect() {
        RECT rect = new RECT();
        User32.INSTANCE.SystemParametersInfoW(48, 0, rect, 0);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    private static boolean isIE(Pointer ie) {
        Boolean cache = ieCache.get(ie);
        if (cache != null) {
            return cache;
        }
        char[] title = new char[1024];
        int titleLength = User32.INSTANCE.GetWindowTextW(ie, title, 1024);
        try {
            String window;
            BufferedReader br = new BufferedReader(new FileReader("windows.txt"));
            while ((window = br.readLine()) != null) {
                if (!new String(title, 0, titleLength).contains(window)) continue;
                ieCache.put(ie, true);
                return true;
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File Not Found Exception: windows.txt not found");
        }
        catch (IOException fnfe) {
            System.out.println("Error: String is invalid. You may have entered an invalid Window name.");
        }
        char[] className = new char[1024];
        int classNameLength = User32.INSTANCE.GetClassNameW(ie, className, 1024);
        if (new String(className, 0, classNameLength).contains("IMWindowClass")) {
            ieCache.put(ie, true);
            return true;
        }
        ieCache.put(ie, false);
        return false;
    }

    private static Pointer findActiveIE() {
        Pointer ie = User32.INSTANCE.GetWindow(User32.INSTANCE.GetForegroundWindow(), 0);
        while (User32.INSTANCE.IsWindow(ie) != 0) {
            if (User32.INSTANCE.IsWindowVisible(ie) != 0) {
                if ((User32.INSTANCE.GetWindowLongW(ie, -16) & 0x1000000) != 0) {
                    return null;
                }
                if (WindowsEnvironment.isIE(ie) && User32.INSTANCE.IsIconic(ie) == 0) break;
            }
            ie = User32.INSTANCE.GetWindow(ie, 2);
        }
        if (User32.INSTANCE.IsWindow(ie) == 0) {
            return null;
        }
        return ie;
    }

    private static Rectangle getActiveIERect() {
        Pointer ie = WindowsEnvironment.findActiveIE();
        RECT out = new RECT();
        User32.INSTANCE.GetWindowRect(ie, out);
        RECT in = new RECT();
        if (WindowsEnvironment.getWindowRgnBox(ie, in) == 0) {
            in.left = 0;
            in.top = 0;
            in.right = out.right - out.left;
            in.bottom = out.bottom - out.top;
        }
        return new Rectangle(out.left + in.left, out.top + in.top, in.Width(), in.Height());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getWindowRgnBox(Pointer window, RECT rect) {
        Pointer hRgn = Gdi32.INSTANCE.CreateRectRgn(0, 0, 0, 0);
        try {
            if (User32.INSTANCE.GetWindowRgn(window, hRgn) == 0) {
                int n = 0;
                return n;
            }
            Gdi32.INSTANCE.GetRgnBox(hRgn, rect);
            int n = 1;
            return n;
        }
        finally {
            Gdi32.INSTANCE.DeleteObject(hRgn);
        }
    }

    private static boolean moveIE(Pointer ie, Rectangle rect) {
        if (ie == null) {
            return false;
        }
        RECT out = new RECT();
        User32.INSTANCE.GetWindowRect(ie, out);
        RECT in = new RECT();
        if (WindowsEnvironment.getWindowRgnBox(ie, in) == 0) {
            in.left = 0;
            in.top = 0;
            in.right = out.right - out.left;
            in.bottom = out.bottom - out.top;
        }
        User32.INSTANCE.MoveWindow(ie, rect.x - in.left, rect.y - in.top, rect.width + out.Width() - in.Width(), rect.height + out.Height() - in.Height(), 1);
        return true;
    }

    private static void restoreAllIEs() {
        RECT workArea = new RECT();
        User32.INSTANCE.SystemParametersInfoW(48, 0, workArea, 0);
        Pointer ie = User32.INSTANCE.GetWindow(User32.INSTANCE.GetForegroundWindow(), 0);
        while (User32.INSTANCE.IsWindow(ie) != 0) {
            if (WindowsEnvironment.isIE(ie)) {
                RECT rect = new RECT();
                User32.INSTANCE.GetWindowRect(ie, rect);
                if (rect.right > workArea.left + 100 && rect.bottom > workArea.top + 100 && rect.left < workArea.right - 100 && rect.top < workArea.bottom - 100) break;
                rect.OffsetRect(workArea.left + 100 - rect.left, workArea.top + 100 - rect.top);
                User32.INSTANCE.MoveWindow(ie, rect.left, rect.top, rect.Width(), rect.Height(), 1);
                User32.INSTANCE.BringWindowToTop(ie);
                break;
            }
            ie = User32.INSTANCE.GetWindow(ie, 2);
        }
    }

    @Override
    public void tick() {
        super.tick();
        workArea.set(WindowsEnvironment.getWorkAreaRect());
        Rectangle ieRect = WindowsEnvironment.getActiveIERect();
        activeIE.setVisible(ieRect != null && ieRect.intersects(this.getScreen().toRectangle()));
        activeIE.set(ieRect == null ? new Rectangle(-1, -1, 0, 0) : ieRect);
    }

    @Override
    public void moveActiveIE(Point point) {
        WindowsEnvironment.moveIE(WindowsEnvironment.findActiveIE(), new Rectangle(point.x, point.y, activeIE.getWidth(), activeIE.getHeight()));
    }

    @Override
    public void restoreIE() {
        WindowsEnvironment.restoreAllIEs();
    }

    @Override
    public Area getWorkArea() {
        return workArea;
    }

    @Override
    public Area getActiveIE() {
        return activeIE;
    }

    static {
        workArea = new Area();
        activeIE = new Area();
    }
}

