/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.config;

import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.animation.Pose;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.AnimationInstantiationException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.image.ImagePairLoader;
import com.group_finity.mascot.script.Variable;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnimationBuilder {
    private static final Logger log = Logger.getLogger(AnimationBuilder.class.getName());
    private final String condition;
    private String imageSet = "";
    private final List<Pose> poses = new ArrayList<Pose>();

    public AnimationBuilder(Entry animationNode, String imageSet) throws IOException {
        if (!imageSet.equals("")) {
            this.imageSet = "/" + imageSet;
        }
        this.condition = animationNode.getAttribute("Condition") == null ? "true" : animationNode.getAttribute("Condition");
        log.log(Level.INFO, "Start Reading Animations");
        for (Entry frameNode : animationNode.getChildren()) {
            this.getPoses().add(this.loadPose(frameNode));
        }
        log.log(Level.INFO, "Animations Finished Loading");
    }

    private Pose loadPose(Entry frameNode) throws IOException {
        String imageText = this.imageSet + frameNode.getAttribute("Image");
        String anchorText = frameNode.getAttribute("ImageAnchor");
        String moveText = frameNode.getAttribute("Velocity");
        String durationText = frameNode.getAttribute("Duration");
        String[] anchorCoordinates = anchorText.split(",");
        Point anchor = new Point(Integer.parseInt(anchorCoordinates[0]), Integer.parseInt(anchorCoordinates[1]));
        try {
            ImagePairLoader.load(imageText, anchor);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load image: " + imageText);
            throw new IOException("Failed to load image: " + imageText);
        }
        String[] moveCoordinates = moveText.split(",");
        Point move = new Point(Integer.parseInt(moveCoordinates[0]), Integer.parseInt(moveCoordinates[1]));
        int duration = Integer.parseInt(durationText);
        Pose pose = new Pose(imageText, move.x, move.y, duration);
        log.log(Level.INFO, "ReadPosition({0})", pose);
        return pose;
    }

    public Animation buildAnimation() throws AnimationInstantiationException {
        try {
            return new Animation(Variable.parse(this.getCondition()), this.getPoses().toArray(new Pose[0]));
        }
        catch (VariableException e) {
            throw new AnimationInstantiationException("Failed to evaluate the condition", e);
        }
    }

    private List<Pose> getPoses() {
        return this.poses;
    }

    private String getCondition() {
        return this.condition;
    }
}

