/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.environment.Environment;
import com.group_finity.mascot.image.NativeImage;
import com.group_finity.mascot.image.TranslucentWindow;
import com.sun.jna.Platform;
import java.awt.image.BufferedImage;

public abstract class NativeFactory {
    private static NativeFactory instance;

    public static NativeFactory getInstance() {
        return instance;
    }

    public static void resetInstance() {
        String subpkg = Main.getInstance().getProperties().getProperty("Environment", "generic");
        if (subpkg.equals("generic")) {
            if (Platform.isWindows()) {
                subpkg = "win";
            } else if (Platform.isMac()) {
                subpkg = "mac";
            }
        }
        String basepkg = NativeFactory.class.getName();
        basepkg = basepkg.substring(0, basepkg.lastIndexOf(46));
        try {
            Class<?> impl = Class.forName(basepkg + "." + subpkg + ".NativeFactoryImpl");
            instance = (NativeFactory)impl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Environment getEnvironment();

    public abstract NativeImage newNativeImage(BufferedImage var1);

    public abstract TranslucentWindow newTransparentWindow();

    static {
        NativeFactory.resetInstance();
    }
}

